package jme.test.texture;

import com.jme3.app.SimpleApplication;
import com.jme3.bullet.BulletAppState;
import com.jme3.bullet.collision.shapes.BoxCollisionShape;
import com.jme3.bullet.control.PhysicsControl;
import com.jme3.bullet.control.RigidBodyControl;
import com.jme3.light.DirectionalLight;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue.ShadowMode;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;

public class TestPssmRendering2 extends SimpleApplication {
  // private PssmShadowRenderer pssm;
  private final BulletAppState bulletState = new BulletAppState();

  @Override
  public void simpleInitApp() {
    stateManager.attach(bulletState);

    final Material whiteMat = new Material(assetManager,
        "Common/MatDefs/Light/Lighting.j3md");

    whiteMat.setFloat("Shininess", 0.8f);
    whiteMat.setBoolean("UseMaterialColors", true);
    whiteMat.setColor("Ambient", ColorRGBA.Black);
    whiteMat.setColor("Diffuse", new ColorRGBA(1f, 0f, 0f, 1f));
    whiteMat.setColor("Specular", ColorRGBA.White);
    whiteMat.setReceivesShadows(true);

    // whiteMat.setBoolean("VTangent", true);

    Geometry geo = new Geometry("floor", new Box(new Vector3f(-10, 0, -10),
        new Vector3f(10, 0f, 10)));
    geo.setMaterial(whiteMat);

    PhysicsControl control = new RigidBodyControl(new BoxCollisionShape(
        new Vector3f(10, 0f, 10)), 0f);

    geo.addControl(control);

    rootNode.attachChild(geo);
    bulletState.getPhysicsSpace().add(geo);

    final DirectionalLight dl = new DirectionalLight();
    dl.setDirection(Vector3f.UNIT_Y.negate());
    rootNode.addLight(dl);

    final Material teapotMat = new Material(assetManager,
        "Common/MatDefs/Light/Lighting.j3md");
    teapotMat.setFloat("Shininess", 0.9f);
    teapotMat.setBoolean("UseMaterialColors", true);
    teapotMat.setBoolean("UseAlpha", false);
    teapotMat.setColor("Ambient", ColorRGBA.Black);
    teapotMat.setColor("Diffuse", new ColorRGBA(1f, 1f, 1f, 1f));
    teapotMat.setColor("Specular", ColorRGBA.Gray);

    geo = new Geometry("Object", new Box(.5f, .5f, .5f));
    geo.setMaterial(teapotMat);

    control = new RigidBodyControl(new BoxCollisionShape(new Vector3f(.5f, .5f,
        .5f)), .1f);
    geo.addControl(control);

    geo.rotate(.1f, .1f, .1f);
    geo.setLocalTranslation(0, 10, 0);

    bulletState.getPhysicsSpace().add(geo);
    rootNode.attachChild(geo);

    rootNode.setShadowMode(ShadowMode.CastAndReceive);

    cam.setLocation(new Vector3f(0, 4, 0));
    cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
    cam.setFrustumPerspective(45f, (float) cam.getWidth() / cam.getHeight(),
        .1f, 1000f);
    cam.update();

    // final Vector3f shadowDir = cam.getLocation().negate().normalizeLocal();
    // pssm = new PssmShadowRenderer(assetManager, 512, 3);
    // pssm.setDirection(shadowDir);
    // pssm.setShadowIntensity(.3f);
    // pssm.setLambda(.2f);
    // pssm.setFilterMode(FilterMode.PCF8);
    // viewPort.addProcessor(pssm);

  }

  public static void main(final String[] args) {
    new TestPssmRendering2().start();
  }
}
